//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Server::AcceptConnection()
{
	if(FD_ISSET(LocalListenSocket, &ReadFDS))
	{
		// AcceptConnection- Accepting...

        char StatusTemp[255];

		int FreeClient = 0;
		int Length = 0;
		SOCKET LocalSocket = 0;

		SOCKADDR_IN RemoteClientSocketAddress;

		Length = sizeof(SOCKADDR);
		LocalSocket = accept(LocalListenSocket,(SOCKADDR*)&RemoteClientSocketAddress,&Length);

		if(LocalSocket == SOCKET_ERROR)
		{
			// AcceptConnection- Socket Error
			closesocket(LocalSocket);
			return -1;
		}

		if(LocalSocket == 0)
		{
			// AcceptConnection- Returned 0.
			closesocket(LocalSocket);
			return -1;
		}

		if(Connections == MaxClients)
		{
			// AcceptConnection- Connect Failed. Too Many Clients.

			WSASendDisconnect(LocalSocket, NULL);
			shutdown(LocalSocket, SD_BOTH);
			closesocket(LocalSocket);
			return -1;
		}

		FreeClient = SelectFreeClient();
		if(FreeClient == -1)
		{
			// AcceptConnection- Connect Failed. Not Enough Resources.
			closesocket(LocalSocket);
			return -1;
		}

        if(NextClientID == 10000) NextClientID = 0;
        ClientID[FreeClient] = NextClientID++;
		Connected[FreeClient] = true;
		Socket[FreeClient]	 = LocalSocket;

		Connections++;

        sprintf(StatusTemp, "(%d) Accepted connection[%d] from %s on port %d. Client[%d]", ClientID[FreeClient], Connections, inet_ntoa(RemoteClientSocketAddress.sin_addr), ntohs(RemoteClientSocketAddress.sin_port), FreeClient);
        WriteLog(StatusTemp);

        CTI.MyServer = this;
        CTI.Client = FreeClient;

        IsClientThreadActive[CTI.Client] = false;
        Client_Thread_Handle[CTI.Client] = CreateThread(NULL, 0, Client_Thread, (LPVOID)&CTI, 0, &Client_Thread_ID[CTI.Client]);
        while(!IsClientThreadActive[CTI.Client])
            Sleep(1);

        CTI.MyServer = NULL;
        CTI.Client = -1;

		return FreeClient;
	}

	return -1;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

